<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class City extends Eloquent {

	protected $table = 'city';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'state_id', 'country_id', 'uuid');

	public function country()
	{
		return $this->hasOne('\Country', 'country_id');
	}

	public function state()
	{
		return $this->hasOne('\City', 'state_id');
	}

}