<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Consumers_Addresses extends Eloquent {

	protected $table = 'consumers_addresses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('address', 'street_no', 'status', 'zip_code', 'uuid');

	public function consumerUser()
	{
		return $this->hasOne('ConsumerUsers', 'consumer_user_id');
	}

	public function city()
	{
		return $this->hasOne('City', 'city_id');
	}

	public function country()
	{
		return $this->hasOne('Country', 'country_id');
	}

	public function state()
	{
		return $this->hasOne('State', 'state_id');
	}

}