<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EntityRatings extends Eloquent {

	protected $table = 'entity_ratings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'entity_id', 'rating', 'comment');

	public function user()
	{
		return $this->hasOne('ConsumerUsers', 'user_id');
	}

	public function entity()
	{
		return $this->hasOne('Entities', 'entity_id');
	}

}