<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Payments extends Eloquent {

	protected $table = 'payments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('uuid', 'transaction_id');

	public function order()
	{
		return $this->hasOne('Orders', 'order_id');
	}

	public function paymentMode()
	{
		return $this->hasOne('PaymentMode', 'payment_mode_id');
	}

}