<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Products extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description', 'status', 'p_cat_id', 'uuid');

	public function products()
	{
		return $this->hasOne('\ProductCategories', 'p_cat_id');
	}

}