<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Sponsored extends Eloquent {

	protected $table = 'sponsored';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('entity_id', 'status', 'start_date', 'end_date');

	public function entity()
	{
		return $this->hasOne('Entities', 'entity_id');
	}

}