<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class State extends Eloquent {

	protected $table = 'state';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'country_id', 'uuid');

	public function country()
	{
		return $this->hasOne('\Country', 'country_id');
	}

}