<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TagAssigned extends Eloquent {

	protected $table = 'tags_assigned';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('uuid');

	public function entity()
	{
		return $this->hasOne('Entities', 'entity_id');
	}

	public function tags()
	{
		return $this->hasOne('Tags', 'tag_id');
	}

}