<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Taxes extends Eloquent {

	protected $table = 'taxes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('tax_percentage', 'country_id');

	public function country()
	{
		return $this->hasOne('\Country', 'country_id');
	}

	public function taxtype()
	{
		return $this->hasOne('\TaxType', 'tax_type');
	}

}