<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Vouchers extends Eloquent {

	protected $table = 'vouchers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'type_id', 'discount', 'start_date', 'end_date', 'entity_id', 'status');

	public function voucher()
	{
		return $this->hasOne('\VoucherType', 'voucher_type');
	}

	public function Entities()
	{
		return $this->hasOne('\Entities', 'entity_id');
	}

}