<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OderDetails extends Model 
{

    protected $table = 'order_details';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'product_id', 'description', 'quantity', 'uuid');

    public function order()
    {
        return $this->hasOne('Orders', 'order_id');
    }

    public function product()
    {
        return $this->hasOne('Products', 'product_id');
    }

}