<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class State extends Model 
{

    protected $table = 'state';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'country_id', 'uuid');

    public function country()
    {
        return $this->hasOne('\Country', 'country_id');
    }

}