<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payments extends Model 
{

    protected $table = 'payments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('uuid', 'transaction_id');

    public function order()
    {
        return $this->hasOne('Orders', 'order_id');
    }

    public function paymentMode()
    {
        return $this->hasOne('PaymentMode', 'payment_mode_id');
    }

}