<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntitiesTable extends Migration {

	public function up()
	{
		Schema::create('entities', function(Blueprint $table) {
			$table->increments('id', true)->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->uuid('uuid', 90);
			$table->string('name', 255)->nullable();
			$table->enum('entity_type', array('('RESTURANT'', ''PHARMACY')'));
		});
	}

	public function down()
	{
		Schema::drop('entities');
	}
}