<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConsumersAddressesTable extends Migration {

	public function up()
	{
		Schema::create('consumers_addresses', function(Blueprint $table) {
			$table->increments('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->string('address', 255);
			$table->string('street_no', 255);
			$table->string('status', 255);
			$table->string('zip_code', 255);
			$table->integer('consumer_user_id')->unsigned();
			$table->integer('country_id')->unsigned();
			$table->integer('state_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->uuid('uuid', 90);
		});
	}

	public function down()
	{
		Schema::drop('consumers_addresses');
	}
}