<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255)->nullable();
			$table->string('description', 255)->nullable();
			$table->tinyInteger('status')->nullable()->default('0');
			$table->integer('p_cat_id')->unsigned()->nullable();
			$table->uuid('uuid', 90);
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}