<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAuditTrailTable extends Migration {

	public function up()
	{
		Schema::create('audit_trail', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('contact_id')->unsigned();
			$table->string('trailable_type', 255)->index();
			$table->integer('trailable_id')->unsigned()->index();
			$table->text('trailable_value')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('audit_trail');
	}
}