<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Company extends Eloquent {

	protected $table = 'companies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function contacts()
	{
		return $this->hasMany('Contact');
	}

	public function address()
	{
		return $this->belongsTo('Address');
	}

	public function application()
	{
		return $this->morphToMany('ApplicationCompany');
	}

	public function infrastucture()
	{
		return $this->belongsTo('Infrastructure');
	}

}