<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('main_address_id')->references('id')->on('addresses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('main_infrastructure_id')->references('id')->on('infrastructures')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('persons', function(Blueprint $table) {
			$table->foreign('main_address_id')->references('id')->on('addresses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->foreign('person_id')->references('id')->on('persons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->foreign('company_address_id')->references('id')->on('addresses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->foreign('current_infrastructure_id')->references('id')->on('infrastructures')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->foreign('api_id')->references('id')->on('apis')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('password_requests', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('countries', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('currency_rates', function(Blueprint $table) {
			$table->foreign('base_currency_id')->references('id')->on('currencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('currency_rates', function(Blueprint $table) {
			$table->foreign('rate_currency_id')->references('id')->on('currencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('applications_companies', function(Blueprint $table) {
			$table->foreign('application_id')->references('id')->on('applications')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('applications_companies', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('audit_trail', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('apis', function(Blueprint $table) {
			$table->foreign('application_id')->references('id')->on('applications')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('infrastructures', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('actors', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('companies_options', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('companies_options', function(Blueprint $table) {
			$table->foreign('application_id')->references('id')->on('applications')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('actor_scope', function(Blueprint $table) {
			$table->foreign('actor_id')->references('id')->on('actors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_main_address_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_main_infrastructure_id_foreign');
		});
		Schema::table('persons', function(Blueprint $table) {
			$table->dropForeign('persons_main_address_id_foreign');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->dropForeign('contacts_person_id_foreign');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->dropForeign('contacts_company_id_foreign');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->dropForeign('contacts_company_address_id_foreign');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->dropForeign('contacts_current_infrastructure_id_foreign');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->dropForeign('contacts_api_id_foreign');
		});
		Schema::table('password_requests', function(Blueprint $table) {
			$table->dropForeign('password_requests_contact_id_foreign');
		});
		Schema::table('countries', function(Blueprint $table) {
			$table->dropForeign('countries_currency_id_foreign');
		});
		Schema::table('currency_rates', function(Blueprint $table) {
			$table->dropForeign('currency_rates_base_currency_id_foreign');
		});
		Schema::table('currency_rates', function(Blueprint $table) {
			$table->dropForeign('currency_rates_rate_currency_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_country_id_foreign');
		});
		Schema::table('applications_companies', function(Blueprint $table) {
			$table->dropForeign('applications_companies_application_id_foreign');
		});
		Schema::table('applications_companies', function(Blueprint $table) {
			$table->dropForeign('applications_companies_company_id_foreign');
		});
		Schema::table('audit_trail', function(Blueprint $table) {
			$table->dropForeign('audit_trail_contact_id_foreign');
		});
		Schema::table('apis', function(Blueprint $table) {
			$table->dropForeign('apis_application_id_foreign');
		});
		Schema::table('infrastructures', function(Blueprint $table) {
			$table->dropForeign('infrastructures_country_id_foreign');
		});
		Schema::table('actors', function(Blueprint $table) {
			$table->dropForeign('actors_contact_id_foreign');
		});
		Schema::table('companies_options', function(Blueprint $table) {
			$table->dropForeign('companies_options_company_id_foreign');
		});
		Schema::table('companies_options', function(Blueprint $table) {
			$table->dropForeign('companies_options_application_id_foreign');
		});
		Schema::table('actor_scope', function(Blueprint $table) {
			$table->dropForeign('actor_scope_actor_id_foreign');
		});
	}
}