<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Contact extends Eloquent {

	protected $table = 'contacts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function address()
	{
		return $this->belongsTo('Address');
	}

	public function api()
	{
		return $this->belongsTo('Api');
	}

	public function infrastucture()
	{
		return $this->belongsTo('Infrastructure');
	}

}