<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('main_address_id')->unsigned();
			$table->integer('main_infrastructure_id')->unsigned();
			$table->string('name', 100);
			$table->string('picture', 255)->nullable();
			$table->string('vhost_url', 255);
			$table->string('db_write_host', 255)->nullable();
			$table->string('db_name', 255)->nullable();
			$table->string('db_login', 255)->nullable();
			$table->string('db_password', 255)->nullable();
			$table->string('api_local_url', 255)->nullable();
			$table->string('api_local_token', 255)->nullable();
			$table->boolean('option_international');
			$table->timestamps();
			$table->tinyInteger('status')->index();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}