<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePersonsTable extends Migration {

	public function up()
	{
		Schema::create('persons', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('main_address_id')->unsigned();
			$table->string('firstname', 100)->index();
			$table->string('lastname', 100)->index();
			$table->string('personal_email', 255);
			$table->string('title', 100);
			$table->string('mobile_phone');
			$table->string('skype', 100);
			$table->tinyInteger('status')->unsigned()->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('persons');
	}
}