<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccAcountTransfer extends Model 
{

    protected $table = 'acc_account_transfer';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'date', 'refrence', 'description', 'paid_from_bank_account_id', 'amount', 'received_in_bank_account_id', 'footer_id', 'cleared_type', 'cleared_at');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function paid_from_bank_account()
    {
        return $this->belongsTo('AccBankAccount', 'paid_from_bank_account_id');
    }

    public function received_in_bank_account()
    {
        return $this->belongsTo('AccBankAccount', 'received_in_bank_account_id');
    }

    public function footer()
    {
        return $this->belongsTo('AccFooter', 'footer_id');
    }

}