<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccBankAccount extends Model 
{

    protected $table = 'acc_bank_account';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'name', 'code', 'currency_id', 'division_id', 'place_id', 'division_place_id', 'control_account_id', 'starting_balance', 'iban', 'have_pending_transaction', 'credit_limit', 'status', 'uncategorized_receipt', 'uncategorized_payment', 'cleared_balance', 'pending_deposit', 'pending_withdrawal', 'actual_balance', 'last_bank_reconciliation', 'available_credit');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function receipts()
    {
        return $this->hasMany('AccReceipt', 'bank_account_id');
    }

    public function division()
    {
        return $this->belongsTo('AccDivision', 'division_id');
    }

    public function control_account()
    {
        return $this->belongsTo('AccControlAccount', 'control_account_id');
    }

    public function place()
    {
        return $this->belongsTo('AccPlace', 'place_id');
    }

    public function division_place()
    {
        return $this->belongsTo('AccDivisionPlace', 'division_place_id');
    }

    public function currency()
    {
        return $this->belongsTo('AccCurrency', 'currency_id');
    }

    public function payments()
    {
        return $this->hasMany('AccPayment', 'bank_account_id');
    }

}