<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccBillableTime extends Model 
{

    protected $table = 'acc_billable_time';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('date', 'description', 'time_spent', 'customer_id', 'division_id', 'place_id', 'division_place_id', 'sales_invoice_id', 'amount', 'status', 'hourly_rate', 'written_off_date', 'user_id');

    public function customer()
    {
        return $this->belongsTo('AccCustomer', 'customer_id');
    }

    public function division()
    {
        return $this->belongsTo('AccDivision', 'division_id');
    }

    public function place()
    {
        return $this->belongsTo('AccPlace', 'place_id');
    }

    public function division_place()
    {
        return $this->belongsTo('AccDivisionPlace', 'division_place_id');
    }

    public function sales_invoice()
    {
        return $this->belongsTo('AccSalesInvoice', 'sales_invoice_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}