<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccCapitalAccount extends Model 
{

    protected $table = 'acc_capital_account';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'code', 'control_account_id', 'division_id', 'division_place_id', 'place_id', 'starting_balance_type', 'starting_balance_amount', 'status', 'user_id', 'balance_sheet_id', 'balance', 'account_category_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function balance_sheet()
    {
        return $this->belongsTo('AccBalanceSheet', 'balance_sheet_id');
    }

    public function division()
    {
        return $this->belongsTo('AccDivision', 'division_id');
    }

    public function place()
    {
        return $this->belongsTo('AccPlace', 'place_id');
    }

    public function division_place()
    {
        return $this->belongsTo('AccDivisionPlace', 'division_place_id');
    }

    public function control_account()
    {
        return $this->belongsTo('AccControlAccount', 'control_account_id');
    }

    public function account_category()
    {
        return $this->belongsTo('AccAccountCategory', 'account_category_id');
    }

}