<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccCapitalSubAccount extends Model 
{

    protected $table = 'acc_capital_sub_account';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'user_id', 'control_account_id', 'balance_sheet_id', 'profit_loss_id', 'account_category_id', 'capital_account_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function control_account()
    {
        return $this->belongsTo('AccControlAccount', 'control_account_id');
    }

    public function balance_sheet()
    {
        return $this->belongsTo('AccBalanceSheet', 'balance_sheet_id');
    }

    public function profit_loss()
    {
        return $this->belongsTo('AccProfitLoss', 'profit_loss_id');
    }

    public function capital_account()
    {
        return $this->belongsTo('AccCapitalAccount', 'capital_account_id');
    }

    public function account_category()
    {
        return $this->belongsTo('AccAccountCategory', 'account_category_id');
    }

}