<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccCreditNote extends Model 
{

    protected $table = 'acc_credit_note';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'customer_id', 'sales_invoice_id', 'inventory_id', 'footer_id', 'date', 'reference', 'description', 'amount', 'billing_address', 'tax_inclusive', 'amounts_are_tax_inclusive', 'withholding_tax_type', 'withholding_tax', 'title');

    public function sales_invoice()
    {
        return $this->belongsTo('AccSalesInvoice', 'sales_invoice_id');
    }

    public function customer()
    {
        return $this->belongsTo('AccCustomer', 'custmer_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function items()
    {
        return $this->hasMany('AccItem', 'credit_note_id');
    }

    public function footer()
    {
        return $this->belongsTo('AccFooter', 'footer_id');
    }

    public function inventory()
    {
        return $this->belongsTo('AccInventory', 'inventory_id');
    }

}