<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccCustomer extends Model 
{

    protected $table = 'acc_customer';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'status', 'name', 'code', 'credit_limit', 'currency_id', 'billing_address', 'delivery_address', 'email', 'division_id', 'control_account_id', 'available_credit', 'total_available_credit', 'receipt', 'payment', 'sales_quote', 'sales_order', 'sales_invoice', 'credit_note', 'delivery_note', 'quantity_delivery', 'quantity_invoice', 'univoiced', 'account_receivable', 'withholding_tax', 'money_status', 'place_id', 'division_place_id', 'starting_balance', 'autofill_sales_invoice', 'autofill_billable_time', 'billable_time_hourly_rate', 'sales_invoice_due_date');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function division()
    {
        return $this->belongsTo('AccDivision', 'division_id');
    }

    public function control_account()
    {
        return $this->belongsTo('AccControlAccount', 'control_account_id');
    }

    public function place()
    {
        return $this->belongsTo('AccPlace', 'place_id');
    }

    public function division_place()
    {
        return $this->belongsTo('AccDivisionPlace', 'division_place_id');
    }

    public function currency()
    {
        return $this->belongsTo('AccCurrency', 'currency_id');
    }

}