<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccDivisionPlace extends Model 
{

    protected $table = 'acc_division_place';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('place_id', 'division_id', 'name', 'status');

    public function place()
    {
        return $this->belongsTo('AccPlace', 'place_id');
    }

    public function division()
    {
        return $this->belongsTo('AccDivision', 'division_id');
    }

}