<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccExpenseClaim extends Model 
{

    protected $table = 'acc_expense_claim';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'date', 'reference', 'paid_by_id', 'capital_account_id', 'payee', 'currency_id', 'description', 'amount', 'footer_id', 'paid_by_type', 'inventory_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function footer()
    {
        return $this->belongsTo('AccFooter', 'footer_id');
    }

    public function capital_account()
    {
        return $this->belongsTo('AccCapitalAccount', 'capital_account_id');
    }

    public function paid_by()
    {
        return $this->belongsTo('AccExpenseClaimPayers', 'paid_by_id');
    }

    public function items()
    {
        return $this->hasMany('AccItem', 'expense_claim_id');
    }

    public function currency()
    {
        return $this->belongsTo('AccCurrency', 'currency_id');
    }

    public function inventory()
    {
        return $this->belongsTo('AccInventory', 'inventory_id');
    }

}