<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccExpenseClaimPayers extends Model 
{

    protected $table = 'acc_expense_claim_payers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'balance_type', 'starting_balance', 'division_id', 'user_id', 'status', 'place_id', 'division_place_id');

    public function division()
    {
        return $this->belongsTo('AccDivision', 'division_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function place()
    {
        return $this->belongsTo('AccPlace', 'place_id');
    }

    public function division_place()
    {
        return $this->belongsTo('AccDivisionPlace', 'division_place_id');
    }

}