<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccHistory extends Model 
{

    protected $table = 'acc_history';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('date', 'action', 'description', 'user_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}