<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccProfitLoss extends Model 
{

    protected $table = 'acc_profit_loss';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'group_type', 'parent_id', 'user_id');

    public function parent()
    {
        return $this->belongsTo('AccProfitLoss', 'parent_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function profit_loss_accounts()
    {
        return $this->hasMany('AccProfitLossAccount', 'profit_loss_id');
    }

    public function subaccounts()
    {
        return $this->hasMany('AccCapitalSubAccount', 'profit_loss_id');
    }

}