<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccProfitLossAccount extends Model 
{

    protected $table = 'acc_profit_loss_account';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'name', 'code', 'profit_loss_id', 'cash_flow_type_id', 'cash_flow_id', 'description', 'status', 'division_id', 'place_id', 'division_place_id', 'account_category_id', 'tax_code_id');

    public function profit_loss()
    {
        return $this->belongsTo('AccProfitLoss', 'profit_loss_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function cash_flow()
    {
        return $this->belongsTo('AccCashFlow', 'cash_flow_id');
    }

    public function cash_flow_type()
    {
        return $this->belongsTo('AccCashFlowType', 'cash_flow_type_id');
    }

    public function division_place()
    {
        return $this->belongsTo('AccDivisionPlace', 'division_place_id');
    }

    public function place()
    {
        return $this->belongsTo('AccPlace', 'place_id');
    }

    public function division()
    {
        return $this->belongsTo('AccDivision', 'division_id');
    }

    public function account_category()
    {
        return $this->belongsTo('AccAccountCategory', 'account_category_id');
    }

    public function tax_code()
    {
        return $this->belongsTo('AccTaxCode', 'tax_code_id');
    }

}