<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccSalesInvoice extends Model 
{

    protected $table = 'acc_sales_invoice';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('status', 'user_id', 'footer_id', 'customer_id', 'date', 'due_date', 'due_type', 'reference', 'billing_address', 'description', 'amount', 'title', 'sub_total', 'withholding_tax', 'total', 'cancelled', 'show_item_image', 'hide_total', 'withholding_tax_type', 'day', 'early_payment_discount', 'early_payment_discount_type', 'early_payment_discount_number', 'if_paid_within_day', 'late_payment_fee', 'charge_monthly', 'invoice_amount', 'balance_due', 'days_to_due_date', 'days_overdue', 'sales_quote_id', 'sales_order_id', 'inventory_id', 'money_staus');

    public function items()
    {
        return $this->hasMany('AccItem', 'sales_invoice_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function footer()
    {
        return $this->belongsTo('AccFooter', 'footer_id');
    }

    public function customer()
    {
        return $this->belongsTo('AccCustomer', 'customer_id');
    }

    public function sales_quote()
    {
        return $this->belongsTo('AccSalesQuote', 'sales_quote_id');
    }

    public function sales_order()
    {
        return $this->belongsTo('AccSalesOrder', 'sales_order_id');
    }

    public function inventory()
    {
        return $this->belongsTo('AccInventory', 'inventory_id');
    }

}