<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccSalesOrder extends Model 
{

    protected $table = 'acc_sales_order';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'footer_id', 'customer_id', 'sales_quote_id', 'date', 'reference', 'description', 'amount', 'billing_address', 'title', 'status', 'sub_total', 'withholding_tax', 'total', 'cancelled', 'show_item_image', 'hide_total', 'withholding_tax_type', 'quantity_delivery', 'delivery_status', 'invoice_amount', 'invoice_status', 'sales_quotes', 'closed_invoice');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function footer()
    {
        return $this->belongsTo('AccFooter', 'footer_id');
    }

    public function customer()
    {
        return $this->belongsTo('AccCustomer', 'customer_id');
    }

    public function sales_quote()
    {
        return $this->belongsTo('AccSalesQuote', 'sales_quote_id');
    }

    public function items()
    {
        return $this->hasMany('AccItem', 'sales_order_id');
    }

}