<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccSalesQuote extends Model 
{

    protected $table = 'acc_sales_quote';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'footer_id', 'customer_id', 'date', 'expiry_date', 'valid_days', 'reference', 'billing_address', 'description', 'amount', 'title', 'status', 'sub_total', 'withholding_tax', 'total', 'cancelled', 'show_item_image', 'hide_total', 'withholding_tax_type');

    public function items()
    {
        return $this->hasMany('AccItem', 'sales_quote_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function customer()
    {
        return $this->belongsTo('AccCustomer', 'customer_id');
    }

    public function footer()
    {
        return $this->belongsTo('AccFooter', 'footer_id');
    }

}