<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'phone', 'password', 'date_of_birth', 'last_donation');

    public function donationRequests()
    {
        return $this->hasMany('App\DonationRequest', 'client_id');
    }

    public function governrates()
    {
        return $this->belongsToMany('App\Governorate', 'client_id');
    }

    public function favorites()
    {
        return $this->belongsToMany('App\Post', 'client_id');
    }

    public function bloodType()
    {
        return $this->belongsToMany('App\BloodTypes');
    }

    public function notifications()
    {
        return $this->belongsToMany('App\Notification', 'client_id');
    }

    public function contactUs()
    {
        return $this->hasMany('App\ContactUs', 'client_id');
    }

}