<?php

namespace App;

class Post extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;
	protected $fillable = array('title', 'body', 'image', 'published_at');

	public function category()
	{
		return $this->belongsTo('App\Category', 'post_id');
	}

	public function clientFavorites()
	{
		return $this->belongsToMany('App\Client', 'client_id');
	}

}