<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Post extends Model 
{

    protected $table = 'posts';
    public $timestamps = true;
    protected $fillable = array('title', 'body', 'image', 'published_at');

    public function category()
    {
        return $this->belongsTo('App\Category', 'post_id');
    }

    public function clientFavorites()
    {
        return $this->belongsToMany('App\Client', 'client_id');
    }

}