<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Notification extends Model 
{

    protected $table = 'notifications';
    public $timestamps = true;
    protected $fillable = array('title');
    protected $visible = array('body');

    public function clientsOfNotefication()
    {
        return $this->belongsToMany('App\Client', 'notification_id');
    }

    public function request()
    {
        return $this->belongsTo('App\DonationRequest');
    }

}