<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('watched_lessons', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('watched_lessons', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('watched_lessons', function(Blueprint $table) {
			$table->dropForeign('watched_lessons_user_id_foreign');
		});
		Schema::table('watched_lessons', function(Blueprint $table) {
			$table->dropForeign('watched_lessons_lesson_id_foreign');
		});
	}
}