<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLearnersTable extends Migration {

	public function up()
	{
		Schema::create('learners', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('address_id')->unsigned();
			$table->integer('living_with')->unsigned();
			$table->integer('religion')->unsigned();
			$table->string('last_name');
			$table->string('first_name');
			$table->string('middle_name');
			$table->string('extension_name');
			$table->string('nickname');
			$table->string('sex', 1);
			$table->date('date_of_birth');
			$table->string('hand', 1);
			$table->string('id_number')->unique();
			$table->string('lrn')->unique();
		});
	}

	public function down()
	{
		Schema::drop('learners');
	}
}