<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Queja extends Model 
{

    protected $table = 'quejas';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function categoria()
    {
        return $this->belongsTo('QuejaCategoria');
    }

    public function agencia()
    {
        return $this->belongsTo('Agencia');
    }

    public function usuario()
    {
        return $this->belongsTo('Usuario');
    }

}