<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuejasTable extends Migration {

	public function up()
	{
		Schema::create('quejas', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_categoria')->unsigned();
			$table->integer('id_agencia')->unsigned();
			$table->integer('id_usuario')->unsigned()->nullable();
			$table->text('comentario');
			$table->string('nombre')->nullable();
			$table->string('identidad')->nullable();
			$table->string('telefono')->nullable();
			$table->string('correo')->nullable();
			$table->string('estado')->default('nueva');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('quejas');
	}
}