<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('quejas', function(Blueprint $table) {
			$table->foreign('id_categoria')->references('id')->on('quejas_categorias')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quejas', function(Blueprint $table) {
			$table->foreign('id_agencia')->references('id')->on('agencias')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quejas', function(Blueprint $table) {
			$table->foreign('id_usuario')->references('id')->on('usuarios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('agencias', function(Blueprint $table) {
			$table->foreign('id_ciudad')->references('id')->on('ciudades')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quejas_historial', function(Blueprint $table) {
			$table->foreign('id_usuario')->references('id')->on('usuarios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quejas_historial', function(Blueprint $table) {
			$table->foreign('id_queja')->references('id')->on('quejas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('usuarios', function(Blueprint $table) {
			$table->foreign('id_agencia')->references('id')->on('agencias')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('departamentos', function(Blueprint $table) {
			$table->foreign('id_region')->references('id')->on('regiones')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ciudades', function(Blueprint $table) {
			$table->foreign('id_departamento')->references('id')->on('departamentos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('quejas', function(Blueprint $table) {
			$table->dropForeign('quejas_id_categoria_foreign');
		});
		Schema::table('quejas', function(Blueprint $table) {
			$table->dropForeign('quejas_id_agencia_foreign');
		});
		Schema::table('quejas', function(Blueprint $table) {
			$table->dropForeign('quejas_id_usuario_foreign');
		});
		Schema::table('agencias', function(Blueprint $table) {
			$table->dropForeign('agencias_id_ciudad_foreign');
		});
		Schema::table('quejas_historial', function(Blueprint $table) {
			$table->dropForeign('quejas_historial_id_usuario_foreign');
		});
		Schema::table('quejas_historial', function(Blueprint $table) {
			$table->dropForeign('quejas_historial_id_queja_foreign');
		});
		Schema::table('usuarios', function(Blueprint $table) {
			$table->dropForeign('usuarios_id_agencia_foreign');
		});
		Schema::table('departamentos', function(Blueprint $table) {
			$table->dropForeign('departamentos_id_region_foreign');
		});
		Schema::table('ciudades', function(Blueprint $table) {
			$table->dropForeign('ciudades_id_departamento_foreign');
		});
	}
}