<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Queja extends Eloquent {

	protected $table = 'quejas';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function categoria()
	{
		return $this->belongsTo('QuejaCategoria');
	}

	public function agencia()
	{
		return $this->belongsTo('Agencia');
	}

	public function usuario()
	{
		return $this->belongsTo('Usuario');
	}

}