<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentsTable extends Migration {

	public function up()
	{
		Schema::create('Students', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id');
			$table->string('code', 25);
			$table->string('firstname', 191);
			$table->string('lastname', 191);
			$table->integer('permission_id');
			$table->string('username', 191);
			$table->string('email', 191);
			$table->string('password', 191);
			$table->date('dob');
		});
	}

	public function down()
	{
		Schema::drop('Students');
	}
}