<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('partenaire_id')->references('id')->on('partenaires')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sites', function(Blueprint $table) {
			$table->foreign('partenaire_id')->references('id')->on('partenaires')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('guichets', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('sites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comptes', function(Blueprint $table) {
			$table->foreign('partenaire_id')->references('id')->on('partenaires')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comptes', function(Blueprint $table) {
			$table->foreign('operateur_id')->references('id')->on('operateurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comptes', function(Blueprint $table) {
			$table->foreign('guichet_id')->references('id')->on('guichets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contrats', function(Blueprint $table) {
			$table->foreign('partenaire_id')->references('id')->on('partenaires')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reglements', function(Blueprint $table) {
			$table->foreign('add_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('reglement_id')->references('id')->on('reglements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('compte_id')->references('id')->on('comptes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('add_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('affectation_agents', function(Blueprint $table) {
			$table->foreign('guichet_id')->references('id')->on('guichets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('affectation_agents', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_partenaire_id_foreign');
		});
		Schema::table('sites', function(Blueprint $table) {
			$table->dropForeign('sites_partenaire_id_foreign');
		});
		Schema::table('guichets', function(Blueprint $table) {
			$table->dropForeign('guichets_site_id_foreign');
		});
		Schema::table('comptes', function(Blueprint $table) {
			$table->dropForeign('comptes_partenaire_id_foreign');
		});
		Schema::table('comptes', function(Blueprint $table) {
			$table->dropForeign('comptes_operateur_id_foreign');
		});
		Schema::table('comptes', function(Blueprint $table) {
			$table->dropForeign('comptes_guichet_id_foreign');
		});
		Schema::table('contrats', function(Blueprint $table) {
			$table->dropForeign('contrats_partenaire_id_foreign');
		});
		Schema::table('reglements', function(Blueprint $table) {
			$table->dropForeign('reglements_add_by_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_reglement_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_compte_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_add_by_foreign');
		});
		Schema::table('affectation_agents', function(Blueprint $table) {
			$table->dropForeign('affectation_agents_guichet_id_foreign');
		});
		Schema::table('affectation_agents', function(Blueprint $table) {
			$table->dropForeign('affectation_agents_user_id_foreign');
		});
	}
}